#include "GetPointOsnappedOnCurve.js"

function DoArcContinue()
{
	var ui = moi.ui;
	var arcfactory = moi.command.createFactory( 'arccontinue' );
	var pointpicker = ui.createPointPicker();
	pointpicker.enableOnObjectSnap = true;

	if ( !GetPointOsnappedOnCurve( pointpicker ) )
		return;
		
	arcfactory.setInput( 0, pointpicker.pt );

	ui.beginUIUpdate();
	ui.hideUI( 'FirstPrompt' );
	ui.showUI( 'SecondPrompt' );
	ui.showUI( 'AngleOptions' );
	ui.endUIUpdate();

	pointpicker.enableOnObjectSnap = false;
	pointpicker.bindResultPt( arcfactory.getInput(1) );
	
	ui.commandUI.g_ArcFactory = arcfactory;
	pointpicker.bindFuncPostUpdate( ui.commandUI.OnPoint );

	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return;
			
		if ( pointpicker.event == 'finished' )
			break;
			
		if ( pointpicker.event == 'angleinput' )
		{
			arcfactory.setInput( 2, ui.commandUI.angleinput.value );
			arcfactory.update();
		}
	}

	arcfactory.commit();
}	

DoArcContinue();
